<!DOCTYPE html>
<html>
<head> 
  <meta charset="utf-8"> 
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1"> 
  <title>Register_{{env('APP_NAME')}}</title> 
  <link rel="stylesheet" href="/mbtech/layui.css"> 
  <style>
      body {
    background: #F4F4F4;
}
.common_body{
    background:#F4F4F4;
    background-image: url("/mbtech/bg.png");
    background-size: 100%;
    background-repeat: no-repeat;
}
.hide {
    display: none;
}

.show {
    display: block
}
.header{
    background: none;
    border-radius: 0px 0px 0px 0px;
    height: 30px;
    line-height: 30px;
    padding: 15px;
}
.mail_main{
    margin:30px 15px ;
}
.mail_main .mail_card{
    background: #FFFFFF;
    border-radius: 8px;
    padding: 15px;
    margin: auto;
    margin-bottom: 15px;
    text-align: center;
}
.mail_main .mail_card p{

    font-family: Arial, Arial;
    text-align: left;
    font-style: normal;
    text-transform: none;
}
.mail_main .mail_card .mail_title{
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 16px;
    color: #333333;
    margin-bottom: 10px;
}
.mail_main  .mail_date{
    font-family: Arial, Arial;
    font-weight: 400;
    font-size: 14px;
    color: #818393;
    margin-bottom: 10px;
}
.mail_main .mail_card .mail_contents{
    font-family: Arial, Arial;
    font-weight: 400;
    font-size: 14px;
    color: #666666;
}
.help_header{
    background-image: url("/public/site/img/user/help_bg.png");
    background-repeat: no-repeat;
    background-size: 100% 200px;
    height: 200px;
}
.help_header .title{
    padding-top: 50px;
    padding-left: 20px;
    width: 200px;
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 28px;
    color: #35506F;
    line-height: 22px;
}
.help_header .describe{
    padding-top: 10px;
    padding-left: 20px;
    width: 200px;
    font-family: Arial, Arial;
    font-weight: 400;
    font-size: 16px;
    color: #2A415C;
    line-height: 22px;
}
.help_card{
    margin: 20px;
    padding: 15px 20px;
    background: #2B5CB9;
    border-radius: 8px;
}
.help_card .help_flex{
    display: flex;
    justify-content: left;
}
.help_card .help_flex .logo{
    padding-right: 10px;
}
.help_card .help_flex .logo img{
    width: 60px;height: 60px;
}
.help_card .help_flex .title{
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 18px;
    color: #D6E4FF;
    line-height: 22px;
}
.help_card .help_flex .describe{
    font-family: Arial, Arial;
    font-weight: 400;
    font-size: 14px;
    color: #D6E4FF;
    line-height: 22px;
}
.vip_main{
    margin:  15px;
}

.vip_main .vip_card {
    height: 175px;
    background-size: 100%;
    background-repeat: no-repeat;
    border-radius: 8px 8px 8px 8px;
    padding: 15px;
    margin-top: 15px;
}
.vip_main .vip_card .vip_image{
    height: 60px;
    width: 60px;
    border-radius: 8px 8px 8px 8px;
    text-align: center;
    background: #E7E7E7;

}
.vip_main .vip_card .vip_image img {
    height: 24px;
    width: 24px;
    margin-top: 10px;
    margin-bottom: 10px;

}


.vip_main .vip_card .vip_contents {
    padding: 10px;
    padding-right: 0px;
    ont-family: Arial, Arial;
    font-weight: 400;
    font-size: 13px;
    color: #444444;
    line-height: 22px;
}

.layui-layer-page {
    background-color: #FFFFFF;
    border-radius: 15px;
    box-shadow: 1px 1px 50px rgba(0, 0, 0, .3);
}
.layui-layer-page .content{
    padding: 20px;
}
.layui-layer-page  .content .title{

    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 20px;
    color: #2A415C;
    line-height: 23px;
    text-align: left;
    font-style: normal;
    text-transform: none;
    border-bottom: 1px solid #F5F5F5;
    padding-bottom: 10px;

}
.layui-layer-page .content .flex{
    margin-top: 20px;
    display: flex;
    justify-content: left;
}
.layui-layer-page .content .flex .logo{
   height: 100px;
    width: 100px;

}
.layui-layer-page .content .flex .logo img{
    padding: 10px;
    width: 80px;
    height: auto;
}
.layui-layer-page .content .flex .app_name{
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 20px;
    color: #2A415C;
    line-height: 23px;
    text-align: left;
    font-style: normal;
    text-transform: none;
    margin-bottom: 8px;
}
.layui-layer-page .content .flex .app_description{
    font-family: Arial, Arial;
    font-weight: 400;
    font-size: 14px;
    color: #818393;
    line-height: 16px;
    text-align: left;
    font-style: normal;
    text-transform: none;
}

.common_header{
    height: 60px;
    width: 100%;
    border: none;
}

.common_header_order {

}
.common_header .back{
    display: block;
    width: 100%;
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 20px;
    color: #FFFFFF;
    text-align: center;
    padding: 15px 0;
    padding-top: 20px;
    line-height: 36px;
}
.common_header .back .btn{
    width: 36px;
    height: 36px;
    line-height: 36px;
    text-align: center;
    position: absolute;
    top:20px;
    left: 15px;
}
.common_header .back .service{
    position: absolute;
    top:15px;
    right: 15px;
    width: 36px;
    height: 36px;
    line-height: 36px;
    background: #2250A8;
    border-radius: 12px 12px 12px 12px;
    border: 1px solid #3060B9;
}
.common_header .back .service img{
     width: 19px;
     height: 19px;
}
.index_header{
    position: relative;
    /*padding: 15px;*/
    /*padding-bottom: 0px;*/
    /*background: linear-gradient( 177deg, #FFFFFF 0%, #F4F4F4 100%);*/
}

.common_main{
    overflow: hidden;
    background: #F4F4F4;
    border-radius: 8px;
    margin: 15px;
}
.common_bg{
    background: #ffffff;
    border-radius: 16px 16px 0px 0px;=
    padding: 15px;
}
.index_header .index_logo{
    margin-top: 5px;
    display: flex;
    justify-content: space-between;
    height: auto;
}

.menu_item{
    background: #FFFFFF;
    border-radius: 8px;
    padding: 10px;
    display: block;
    text-align: center;
}
.menu_item .menu_title{
    margin-top: 5px;
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 14px;
    color: #155CCD;
    line-height: 16px;
}
.menu_item .menu_desc{
    margin-top: 5px;
    font-family: Arial, Arial;
    font-weight: 400;
    font-size: 12px;
    color: #ADADAD;
    line-height: 14px;
}
.index_header_card {
    background: linear-gradient( 132deg, #398346 0%, #1D964E 100%);
    box-shadow: 0px 4px 20px 0px rgba(19,129,64,0.3);
    border-radius: 30px 30px 30px 30px;
    padding: 20px;margin-top: 20px;
}
.index_header_card .title{
    font-family: Ysabeau SC, Ysabeau SC;
    font-weight: 700;
    font-size: 24px;
    color: #FFFFFF;
    line-height: 32px;
}
.index_header_card .desc{
    margin-top: 7px;
    font-family: Oxanium, Oxanium;
    font-weight: 400;
    font-size: 14px;
    color: #CBF7DC;
}
.balance .label{
    font-family: Arial, Arial;
    font-weight: 400;
    font-size: 12px;
    color: #888888;
}
.balance .value{
    margin-top: 10px;
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 13px;
    color: #0F7A5A;
}
.index_header .index_menu {
    background: #FFFFFF;
    border-radius: 10px 10px 10px 10px;
    padding: 10px;
    margin-top: 15px;
    display: flex;
    justify-content: space-between;
    margin-bottom: 10px;
    height: auto;
    padding-bottom: 0px;
}
.index_header .index_menu img{
    height: 50px;
    width: 50px;
}
.index_header .index_menu .menu-title{
    font-family: PingFang SC, PingFang SC;
    font-weight: 400;
    font-size: 14px;
    color: #474747;
    line-height: 20px;
    text-align: center;
    margin-top: 5px;
}
.index_banner{
    height: 190px;
    background-image: url("/public/site/img/index/banner_bg.png");
    background-size: 100% auto;
    background-repeat: no-repeat;
    border-radius: 25px;
    padding: 15px 24px;
    margin-top: 15px;
}
.index_banner .title{
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 18px;
    color: #FFFFFF;
    line-height: 21px;
}
.index_banner .label{
     font-family: Arial, Arial;
     font-weight: 400;
     font-size: 15px;
     color: #80A8F4;
     line-height: 17px;
     margin-top: 17px;
    margin-bottom: 6px;
}
.flex_space{
    display: flex;
    justify-content: space-between;
}
.flex_left{
    display: flex;
    justify-content: left;
}
.wallet_btn{
    height: 30px;
    line-height: 30px;
    width:100px;
    background: #17A278;
    border-radius: 8px 8px 8px 8px;
    font-family: PingFang SC, PingFang SC;
    font-weight: 400;
    font-size: 12px;
    color: #FFFFFF;
    text-align: center;
}
.wallet_btn img{ display: inline-block;height: 20px;}
.nav{
    /*height: 40px;*/
    /*line-height: 40px;*/
}
.nav_active{
    background-position: bottom;
    background-repeat: no-repeat;
    background-size: 38px auto;
    text-align: center;
    margin: auto;
    padding-bottom: 0px;
}
.nav .title{
    font-family: Arial, Arial;
    font-weight: 400;
    font-size: 14px;
    color: #333333;
    line-height: 40px;
    margin-bottom: 10px;
}
.nav_active .title{
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 14px;
    color: #1360CB;
    line-height: 40px;
}
.reward_right_card{
    background: #FBF3F1;
    border-radius: 4px 4px 4px 4px;
    padding: 8px;
    margin-bottom: 8px;
}
.reward_right_card .title{
    font-family: PingFang SC, PingFang SC;
    font-weight: 400;
    font-size: 13px;
    color: #373737;
    line-height: 13px;
}
.reward_right_card .label{
    font-family: Arial, Arial;
    font-weight: 400;
    font-size: 11px;
    color: #818393;
    line-height: 13px;
}
.reward_right_card .value{
    font-family: PingFang SC, PingFang SC;
    font-weight: 400;
    font-size: 14px;
    color: #0F7A5A;
    line-height: 20px;
}
.reward_right_card .invite_btn{
    width: 150px;
    height: 40px;
    text-align: center;
    line-height: 40px;
    background: #396ED1;
    border-radius: 100px 100px 100px 100px;
    cursor: pointer;
}
.reward_card .copy_link_btn{
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 14px;
    color: #FFFFFF;
    border-bottom: 2px solid #396AC7;
}
.reward_card .qr_code_btn{
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 14px;
    color: #FFFFFF;
    background: #23AF66;
    border-bottom: 1px solid #80D8AA;
}
.reward_card .title{
    font-family: PingFang SC, PingFang SC;
    font-weight: 400;
    font-size: 16px;
    color: #333333;
    line-height: 22px;
    display: flex;
    justify-content:space-between ;
}
.reward_card .content{
    margin-top: 25px;
    width: 100%;
}
.reward_card .title{
    font-family: PingFang SC, PingFang SC;
    font-weight: 400;
    font-size: 16px;
    color: #373737;
    line-height: 22px;
    margin-bottom: 5px;
}
.reward_card .desc{
    font-family: Arial, Arial;
    font-weight: 400;
    font-size: 12px;
    color: #727272;
    line-height: 14px;
    margin-bottom: 5px;
}

.position{
    position: relative;
}
.unit{
    position: absolute;top: -6px;
    left: -15px;
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 14px;
    color: #CFD0D9;

}
.index_main {
    position: relative;
    margin:0px;
    padding-bottom: 80px;
}

.index_main .product_title{
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 20px;
    color: #242424;
    line-height: 25px;

}
.index_main .product_type{
    margin-bottom: 20px;
}
.index_main .product_type_item{
    width: 30%;
    background: #2452AC;
    border-radius: 100px;
    border: 1px solid #3565C2;
    font-family: Arial, Arial;
    font-weight: 400;
    font-size: 14px;
    color: #FFFFFF;
    padding: 8px;
    text-align: center;
}
.index_main .product_type_item_active{
    width: 30%;
    background: #6298FF;
    border-radius: 100px;
    border: 1px solid #93B8FF;
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 14px;
    color: #FFFFFF;
    padding: 8px;
    text-align: center;
}
.index_main .invite{
    padding: 10px;
}
.index_main .invite .invite_banner{
    position:relative;
    top: -30px;
    width: 100%;
}
.index_main .invite .invite_banner img{
    width: 100%;

}
.index_main .prompt{
    position:relative;
    top: -20px;
    font-family: Arial, Arial;
    font-weight: 400;
    font-size: 14px;
    color: #2A415C;
    line-height: 16px;
    text-align: left;
    font-style: normal;
    text-transform: none;
}
.index_main .commission{
   margin-bottom: 20px;
}
.index_main .commission .flex{
    display: flex;
    justify-content: left;
    padding: 0px;
}
.index_main .commission .flex .left img{
    height: 35px; width: 35px;
}
.index_main .commission .flex .right{
    padding-left: 10px;
}
.index_main .commission .flex .value{
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 18px;
    color: #0E0E0E;
    line-height: 21px;
    text-align: left;
}
.index_main .commission .flex .label{
    font-family: Arial, Arial;
    font-weight: 400;
    font-size: 14px;
    color: #818393;
    line-height: 17px;
    text-align: left;
}
.index_main .link_btn{
    margin: 20px 0;
}
.index_main .link{
    padding: 0 10px;
}
.index_main .link p{
    font-family: Arial, Arial;
    font-weight: 400;
    font-size: 16px;
    color: #B9BDD9;
    line-height: 17px;
    text-align: left;
    margin-bottom: 6px;
}
.index_main .link .my_link{
    font-family: Arial, Arial;
    font-weight: 400;
    font-size: 16px;
    color: #2A415C;

}
.index_main .reward{
    padding: 10px;
}

.index_main .reward .title{
    border-left: 4px #EBD8A3 solid;
    padding-left: 10px;
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 18px;
    color: #2A415C;
    line-height: 21px;
    text-align: left;
    font-style: normal;
    text-transform: none;
}
.index_main .flex{
    margin-top: 20px;
    display: flex;
    justify-content: left;
    padding: 0;
    border-radius: 15px 15px 15px 15px;
}
.index_main .balance{
    padding: 20px;
    background: #FFFFFf;
}

.index_main .reward .flex{
    background: #FBFBFF;
}
.index_main .reward .flex .left{
    background: #FBFBFF;
}
.index_main .reward .flex .left img{
    width: 88px;
    height: 88px;
}
.index_main .reward .flex .right{
    padding-top: 10px;
    padding-left: 10px;
}
.index_main .reward .flex .right .title{
    font-family: Arial, Arial;
    font-weight: 400;
    font-size: 16px;
    color: #2A415C;
    line-height: 18px;
}
.copyright{
    font-family: Arial, Arial;
    font-weight: 400;
    font-size: 14px;
    color: #ABB4BC;
    line-height: 16px;
    text-align: center;
    margin: 15px 0;
}
.none_data{
    text-align: center;margin: auto;padding: 30px 20px;padding-bottom: 60px;
    background: #FFFFFF;
    border-radius: 8px 8px 8px 8px;
}
.none_image{
    width: 107px;height: auto;
}
.none_text{
    margin-top: 15px;
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 18px;
    color: #ADACAC;
    line-height: 21px;
    text-align: center;
}
.card{
    background: #FFFFFF;
    border-radius: 15px 15px 15px 15px;
    margin-bottom: 20px;
}
.product_header{
    position: relative;
    padding: 40px 20px 0 20px; ;
    height: 135px;
    background-image: url("/public/site/img/order/bg.png");
    background-repeat: no-repeat;
    background-size: 100% 175px;
}
.product_header .header_content{
    display: flex;
    justify-content: space-between;
}
.product_header .header_content .service img{
    width: 55px;
    height: 55px;
    border-radius: 50%;
}
.product_header .index_logo{
    width: 200px;
    height: auto;
}
.product_header .index_logo img{
    width: 100%;
    height: auto;
}
.product_main{
    position:relative;
    top: -20px;
    display: flex;
    justify-content: left;
}
.product_main .left_content{
    width: 120px;
}
.product_main .left_content .card{
    width: 90px;
    padding: 10px;
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 14px;
    color: #2A415C;
    line-height: 16px;
    margin-bottom: 8px;
    border-radius: 0px 10px 10px 0px;
    background: #CFD0D9;
}
.product_main .left_content .card img{
    width: 20px;
    height: 20px;
    margin-bottom: 7px;
}
.product_main .left_content .card_active{
    background: linear-gradient( 135deg, #004B6E 0%, #0295C7 100%);
    border-radius: 0px 10px 10px 0px;
    color: #FFFFFF;
}
.product_main .left_content .card_order{
    display: block;
    margin-top: 60px;
    background: #383838;
    border-radius: 0px 10px 10px 0px;
    color: #FFFFFF;
}

.product_main .right_content {
    width: 100%;
    padding: 0 10px;
    margin-bottom: 60px;
}

.product_card{
    background: rgba(255,255,255,1);
    border-radius: 8px 8px 8px 8px;
    padding: 0;
    margin-bottom: 15px;
    display: block;
    width: 100%;
}
.product_card .product_title_card{
    background: none;
    border-radius: 10px 10px 10px 10px;
    padding: 7px;
    font-family: Source Han Sans, Source Han Sans;
    font-weight: 700;
    font-size: 16px;
    color: #000000;
    line-height: 30px;
}
.product_card .product_title_card .lv{
    height: 16px;
    width: 16px;
    line-height: 30px;
}
.product_card .buy{
    width: 80px;
    height: 30px;
    background: linear-gradient( 101deg, #155BCD 2%, #01A9B1 100%);
    border-radius: 100px 100px 100px 100px;
    border: 0px solid #FFFFFF;
    font-family: PingFang SC, PingFang SC;
    font-weight: 400;
    font-size: 14px;
    color: #FFFFFF;
    line-height: 30px;
    text-align: center;
}
.product_card .level{
     position: absolute;
     left: 0px;
     top: 0px;
     width: 35px;
     height: 20px;
     background: linear-gradient( 270deg, #FFD685 0%, #F5E08F 100%);
     border-radius: 8px 0px 8px 0px;
     text-align: center;
     z-index: 999;
}
.product_card .level img{
    width: 13px;
}
.product_card .product_content{
    text-align: center;
    margin-top: 10px;
}
.product_card .product_content .product_image{
    height: 100px;
    width: 100px;
    border-radius: 8px;
    background-size: 100px;
    background-repeat: no-repeat;
}
.product_card .product_content .product_image img{
    height: 100px;
    width: 100px;
    border-radius: 8px;
}
.product_card .product_content .product_title .product_image{
    height: 100px;
    width: 100px;
}
.product_card .product_content .product_title .product_info{
    width: 100%;
    padding: 0 10px;
}
.product_card .product_content .product_title .product_name{
    font-family: PingFang SC, PingFang SC;
    font-weight: 400;
    font-size: 16px;
    color: #373737;
    line-height: 24px;
    margin-bottom: 10px;
    width: 100%;
}
.product_card .product_content  .label{
    font-family: Arial, Arial;
    font-weight: 400;
    font-size: 13px;
    color: #FFFFFF;
    margin-right: 20px;
}
.product_card .product_content  .value{
    font-family: PingFang SC, PingFang SC;
    font-weight: 400;
    font-size: 14px;
    color: #333333;
}
.product_card .product_content  .price{
    color: #0F7A5A;
    font-size: 18px;
    line-height: 20px;
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 20px;
    color: #E7A100;
}
.product_card .product_item{
    text-align: center;
}
.product_card .product_item .label{
    font-family: Arial, Arial;
    font-weight: 400;
    font-size: 13px;
    color: #3D3D3D;
}
.product_card .product_item .value{
    font-family: PingFang SC, PingFang SC;
    font-weight: 400;
    font-size: 14px;
    color: #333333;
    line-height: 14px;
    margin-top: 8px;
    padding-left: 0px;
}

.product_details_main{
    background: #FFFFFF;
    border-radius: 8px;
    margin: 20px;
    margin-top: 80px;
    /*position: absolute;*/
    /*top: 0px;*/
}
.product_details_card{
    position: relative;
    display: block;
    background: #FFFFFF;
    border-radius: 8px;
    padding: 15px;
    margin-bottom: 15px;
}
.product_details_card .lianjie{
    width: 4px;height: 40px;
}
.product_details_card .lianjie_left{
    position: absolute;
    top: -30px;
    left: 30px;
}
.product_details_card .lianjie_right{
    position: absolute;
    top: -30px;
    right: 30px;
}
.common_card .lianjie{
    width: 4px;height: 40px;
}
.common_card .lianjie_left{
    position: absolute;
    top: -30px;
    left: 30px;
}
.common_card .lianjie_right{
    position: absolute;
    top: -30px;
    right: 30px;
}
.product_details_card .product_details_item{
    display: flex;
    justify-content: space-between;
    padding: 15px 0;
    border-bottom: 1px solid #F3F3F3;

}
.product_details_card .product_details_order{
    border-bottom: 1px solid #EAEAEA;
}
.product_details_card .buy_btn{
    background: linear-gradient( 102deg, #27C85D 0%, #24A196 100%);
    box-shadow: 0px 4px 10px 0px rgba(36,165,144,0.3);
    border-radius: 100px 100px 100px 100px;
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 18px;
    color: #FFFFFF;
}
.layui-slider {
    height: 5px;
    background: #eee;
    border-radius: 3px;
    position: relative;
    cursor: pointer;
}
.layui-slider-wrap-btn {
    width: 20px;
    height: 20px;
    border-radius: 50%;
    background:#FFFFFF;
    border: none;
}
.product_details_card .product_details_name{
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 18px;
    color: #666666;
    line-height: 21px;
    margin-bottom: 20px;
}
.product_details_card .product_details_item .label{
    font-family: Arial, Arial;
    font-weight: 400;
    font-size: 14px;
    color: #888888;
    line-height: 16px;
    margin-bottom: 6px;
}
.product_details_card .product_details_item .value{
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 18px;
    color: #666666;
    line-height: 21px;
    text-align: left;
}
.product_details_card .product_details_item .price {
    font-family: Arial, Arial;
    font-weight: normal;
    font-size: 22px;
    color: #FF7D21;
    line-height: 31px;
}
/*.product_details_card .product_details_item .unit {*/
/*    position: relative;*/
/*    top: -10px;*/
/*    font-family: Arial, Arial;*/
/*    font-weight: 700;*/
/*    font-size: 14px;*/
/*    color: #CFD0D9;*/
/*    line-height: 16px;*/
/*}*/
.footer_menu{
    position: fixed;
    z-index:9999;
    bottom: 0px;
    left: 0px;
    right: 0px;
    /*height: 80px;*/
    background:none;
    /*box-shadow: 0px 4px 10px 0px rgba(42,65,92,0.3);*/
    /*border: 1px solid #ACC8FD;*/
    border-radius: 120px 120px 0  0;
    padding: 0;
    margin: 0;
}

.footer_menu .content{
    background: #FFFFFF;
    display: flex;
    width: 100%;
    color: #A1BFF6;
}
.footer_menu .content a{
    color: #A1BFF6 !important;
    font-weight: 400;
}
.footer_menu .content .item{
    padding: 10px;
    width: 25%;
    text-align: center;
    justify-content: center;
}
.footer_menu .content .item img{
    width: 21px;
    height: 21px;
}
.footer_menu .content .item p{
    margin-top: 4px;
    font-family: Arial, Arial;
    font-weight: 400;
    font-size: 14px;
    color: #AFAFAF;
    height: 20px;
    line-height: 20px;
}
.footer_menu .content  .active{
    text-align: center;
    font-family: Arial, Arial;
    font-weight: 400;
    font-size: 14px;
    color: #00A576;
    text-align: center;
}

#service{
    /*display: none;*/
    position: fixed;
    z-index:9999;
    bottom: 200px;
    right: 0px;
    width: 40px;
    height: 40px;
    /*padding: 3px;*/
    /*padding-left: 5px;*/
    /*padding-top: 5px;*/
    box-shadow: 0px 4px 10px 0px rgba(0,0,0,0.1);
    background: linear-gradient( 101deg, #155BCD 2%, #01A9B1 100%);
    border-radius: 50%;
    /*border: 1px solid #7DD8A2;*/
    text-align: center;
}

#service img{
    border-radius: 50%;
}
.login_body{
   background-image: url('/mbtech/download (4).jpg'); /* 👈 Replace with your image URL */
  background-size: cover;        /* ✅ Image fills full area */
  background-position: center;   /* ✅ Center align */
  background-repeat: no-repeat;  /* ✅ No repeat */
  width: 100%;
  height: 100vh;                 /* ✅ Full screen height */
  position: relative;
  display: flex;
  align-items: center;
  justify-content: center;
  text-align: center;

}
.login_body .login_bg{
    height: 100%;
  margin: 0;
  padding: 0;
}
.login_body .main{
    /*background: #3364C1;*/
}

.login_body .logo {
    margin-top: 74px;
    width: 100%;
    text-align: center;
}
.login_body .logo img{
    width: 100px;
    height: 100px;
}
.login_body .logo .footer_order{
    background: #3364C1;
    height: 55px;
    width: 100%;
    border-bottom: 1px solid #ACC8FD;
    border-radius: 160%;
    filter: blur(1px);

}
.login_body .main .login_form{
    background: #FFFFFF;
    border-radius: 8px 8px 8px 8px;
    margin: 24px;
    margin-bottom: 0px;
}
.login_body .main .login_form .form_tab{
   display: flex;
   justify-content: right;
   background: none;
   border-radius: 30px 30px 0px 0px;
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 20px;
    color: #FFFFFF;
    line-height: 50px;
    text-align: center;
    font-style: normal;
    text-transform: none;
}

.login_body .main .login_form .form_tab .left{
    width: 50%;
    height: 60px;
    background:none;
    color: #666666;
    border-radius: 30px 30px 0px 0px;
}
.login_body .main .login_form .form_tab .right{
    width: 50%;
    height: 60px;
    background: none;
    color: #FFFFFF!important;
    border-radius: 30px 30px 0px 0px;
}

.login_body .main .login_form .form_container{
    background: none;
    border-radius: 0px 30px 30px 30px;
    padding: 15px;
}
.login_body .main .login_form .form_container .label{
    font-family: Arial, Arial;
    font-weight: 400;
    font-size: 16px;
    color: blue;
    line-height: 18px;
    margin-bottom: 5px;
}
.login_body .main .login_form .form_container .layui-form-item{
    border-radius: 100px;
    border: 1px solid white;
    margin-bottom: 20px;
    height: 50px;

}
.layui-form-pane .layui-input {
    border-radius: 0 100px 100px 0;
}
.login_body .main .login_form .form_container .layui-form-label{
    width: 100px;
    padding-top: 14px;
    border: none;
    background: none;
    border-right: 1px solid blue;
    height: 30px;
    font-weight: 400;
    font-size: 18px;
    color: black;

}
.login_body .main .login_form .form_container .layui-input-block{
    margin-left: 100px;
    height: 50px;
    line-height: 50px;
}
.login_body .main .login_form .form_container .layui-input-wrap{
    border-radius: 100px;
}
.login_body .main .login_form .form_container .layui-input-wrap .layui-input,.layui-input-affix {
    font-family: Arial, Arial;
    font-weight: 400;
    font-size: 16px;
    color: black !important;
}
.login_body .main .login_form .form_container .layui-input-wrap .layui-input,.layui-input-affix {


    height: 50px !important;
    line-height: 50px !important;
}
.login_btn{
    margin-bottom: 20px;
    height: 50px;
  background: linear-gradient(135deg, red 50%, blue 20%);
    box-shadow: 0px 4px 10px 0px rgba(13,123,191,0.2);
    border-radius: 100px 100px 100px 100px;
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 18px;
    color: #fff;
    font-style: normal;
    text-transform: none;
}
.register_btn{
    margin-bottom: 15px;
    height: 50px;
  background: linear-gradient(135deg, red 50%, blue 20%);
    border-radius: 100px 100px 100px 100px;
    border: 1px solid #E5E5E5;
    font-family: PingFang SC, PingFang SC;
    font-weight: 400;
    font-size: 16px;
    color: #fff;
}
.border_noe{
    border: none;
}

.user_header{
    position: relative;
    background: #2B5CB9;
    border-radius: 12px 12px 12px 12px;
    border: 1px solid #3769C7;
    height: 130px;
    margin:26px 42px;
    padding: 20px 10px;
    margin-bottom: 0px;
    padding-bottom: 0px;
    z-index: 9999999;
}
.user-header .user_info{
    padding-top: 0px;
    z-index: 9999999;
}
.user_info .balance{
    text-align: center;
    margin-top: 15px;
    z-index: 9999999;
}
.user_info .balance .label{
    font-family: Arial, Arial;
    font-weight: 400;
    font-size: 13px;
    color: #96BAF3;
    line-height: 15px;
}
.user_info .balance .value{
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 18px;
    color: #FFE11C;
    margin-bottom: 10px;
}
.user_contents{
    display: flex;
    justify-content: space-between;
    border: 1px #000000;
    z-index: 9999999;
}
.user_contents .info {
    display: flex;
    justify-content: left;
    color: #FFFFFF;
}
.user_contents .info img {
    width: 50px;
    height: 50px;
}
.user_contents .info a {
    font-weight:700 ;
    color: #FFFFFF;
    margin-bottom: 5px;
}
.user_contents .username {
    padding-left: 10px;
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 18px;
    color: #FFFFFF;
    line-height: 21px;
    text-align: left;
    font-style: normal;
    text-transform: none;
}
.user_main{
    background-image: url("/public/site/img/user/bg.png");
    background-size: 100%;
    background-repeat: no-repeat;
    padding: 15px;
    padding-top: 70px;
    padding-bottom: 100px;
    position: relative;
    top: -15px;
    z-index: 111;
}
.user_main .index_menu {
    margin-top: 15px;
    display: flex;
    justify-content: space-between;
    margin-bottom: 10px;
    height: auto;
}
.user_main .index_menu img{
    height: 40px;
    width: 40px;
}
.user_main .index_menu .menu-title{
    margin-top: 6px;
    font-family: Arial, Arial;
    font-weight: 400;
    font-size: 14px;
    color: #FFFFFF;
    line-height: 16px;
    text-align: center;
}
.user_main .nav{
    background-image: url("/public/site/img/common/nav.png");
    background-size:  100% 110px;
    background-repeat: no-repeat;
    height: 110px;
    padding-top: 5px;
}
.user_main .nav_active{
    background-image: url("/public/site/img/common/active_nav.png");
    background-size:  100% 110px;
    background-repeat: no-repeat;
    height: 110px;
    padding-top: 5px;
}
.user_main .nav .title{
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 16px;
    color: #97BBFF;
    line-height: 18px;
    margin-top: 8px;
    margin-bottom: 3px;
}
.user_main .nav .value{
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 14px;
    color: #FFE11C;
    line-height: 16px;
}


.user_main .balance{
    padding: 20px;
}


.user_main .balance .flex{
    display: flex;
    justify-content: space-between;
    padding: 0px;
    margin-top: 15px;

}
.user_main .balance .flex .item{
    width: 50%;
}
.user_main .balance .flex .item .value{
    color: #35506F;
}

.user_main .menu{
    display: flex;
    justify-content: space-between;
    background: none;
}
.user_main .menu .menu_card{
    background: #ffffff;
    border-radius: 8px;
    display: flex;
    justify-content: left;
    padding: 10px;
    height: 40px;
}
.user_main .menu .menu_card .item{
   padding-left: 5px;
}
.user_main .menu .menu_card .item .value{
    font-family: Arial, Arial;
    font-weight: 400;
    font-size: 16px;
    color: #AF8923;
    line-height: 18px;
    text-align: left;
    font-style: normal;
    text-transform: none;
}
.user_main .menu .menu_card .item .label{
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 16px;
    color: #004B6E;
    text-align: left;
    font-style: normal;
    text-transform: none;
    margin-bottom: 5px;
}
.user_main .menu .menu_card img{
    width: 24px;
    height: 24px;
}

.user_main .user_list {
    margin-top: 15px;
    background: #2B5CB9;
    border-radius: 8px;
    border: 1px solid #3769C7;
}
.user_main .user_card{
    margin: 0 15px;
    padding: 15px 0;
    border-bottom: 1px solid #3669C8;
}
.user_main .user_card .item{
    display: flex;
    justify-content: space-between;

}
.user_main .user_card .item .title{
    display: inline-block;
    padding-left: 10px;
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 16px;
    color: #97BBFF;
    line-height: 18px;
}
.user_main .user_card .item img{
    width: 32px;
    height: 32px;
}
.user_main .user_card .item .right_icon{
    color: #CCCCCC;
    line-height: 32px;
    font-weight: bold;
}
.logout{
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 18px;
    color: #97BBFF;
    line-height: 21px;
}
.logout img{
    height: 18px;
    width: 18px;
}
.team_header{
    background-image: url("/mbtech/header_bg.png");
    background-size: 100%;
    background-repeat: no-repeat;
    height: 160px;
}
.team_header .back{
    display: block;
    width: 100%;
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 20px;
    color: #D6E4FF;
    line-height: 22px;
    text-align: center;
    padding-top: 20px;
    line-height: 36px;
}
.team_header .back .btn{
    width: 36px;
    height: 36px;
    background: #2250A8;
    border-radius: 12px 12px 12px 12px;
    border: 1px solid #3060B9;
    line-height: 36px;
    text-align: center;
    position: absolute;
    top: 20px;
    left: 15px;
}


.team_header .label{
    margin-top: 20px;
    font-family: Arial, Arial;
    font-weight: 400;
    font-size: 14px;
    color: #BAD5FF;
    line-height: 22px;
    text-align: center;
    margin-bottom: 12px;
}
.team_header .value{
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 24px;
    color: #FEDD4D;
    line-height: 28px;
    text-align: center;
}
.team_main {
    padding: 0 15px;
    margin-bottom: 200px;
}
.team_card{
    margin-top: 25px;
    background: #ffffff;
    height: 166px;
    padding: 0 17px;
    border-radius: 16px;
}
.team_card .title{
    text-align: center;
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 19px;
    color: #0F7A5A;
    line-height: 22px;
    margin-bottom: 20px;
}
.team_card .left {
    width: 100px !important;
    height: 100px !important;
    background: #3A6BC7;
    border-radius: 8px 8px 8px 8px;
    border: 1px solid #497CDE;
    text-align: center;

}
.team_card .left .level_icon{
    margin-top: 5px;
    width: 44px;
    height: 44px;
}

.team_card .left .label{
    font-family: Arial, Arial;
    font-weight: 400;
    font-size: 11px;
    color: #9EBDF9;
    line-height: 22px;
    margin-bottom: 12px;
}
.team_card .left .value{
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 24px;
    color: #FEDD4D;
    line-height: 28px;
    text-align: center;
    width: 100px;
}
.team_card .right{
    width: 100%;
    /*padding-left: 10px;*/
}
.team_card .right .item{
    width: 100%;
   margin-bottom: 15px;
}
.team_card .right .label{
    font-family: Arial, Arial;
    font-weight: 400;
    font-size: 13px;
    color: #0F7A5A;
    line-height: 22px;
}
.team_card .right .value{
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 16px;
    color: #EBF2FF;
    line-height: 18px;
    padding-left: 12px;
}

.common_card{
    background: rgba(255,255,255,1);
    border-radius: 8px 8px 8px 8px;
    padding: 15px;
    margin-bottom: 20px;
}
.common_card .common_card_content{
    background: #FFFFFF;
    border-radius: 8px;
}

.common_explain{
    border-left: 4px solid #003862;padding-left: 10px;
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 18px;
    color: #003862;
    line-height: 21px;
}
.common_content{
     margin-top: 15px;
     font-family: Arial, Arial;
     font-weight: 400;
     font-size: 14px;
     color: #2A415C;
     line-height: 22px;
}
.common_content p{
   margin-bottom: 15px;
}

.dialog{
    /*background: rgba(255,255,255,0.2);*/
    /*filter:alpha(opacity=.1);*/
    /*border-radius: 16px;*/
    /*border: 2px solid rgba(255,255,255,0.5);*/
    background: #ffffff;
    z-index: 100;
    top: 10px;
    border-radius: 16px;
    padding: 15px 0;
}

.dialog .dialog_contents{
    padding: 16px;
    background-color: #FFFFFf;
    border-radius: 8px;
    z-index: 300;

    /*margin: 15px;*/
}
.dialog .logo{

    width: auto;
    height: 60px;
    margin: auto;
    text-align: center;
}
.dialog .logo img{
    width: auto; height: 60px;
    /*border-radius: 50%;*/
}
.dialog .title{
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 16px;
    color: #333333;
    line-height: 18px;
    margin-bottom: 20px;
}
.dialog .item{
   display: flex;
    justify-content: space-between;
    width: 100%;
    padding: 20px 0;
}
.dialog .item .label{
    font-family: Arial, Arial;
    font-weight: 400;
    font-size: 14px;
    color: #2A415C;
    line-height: 16px;
}
.dialog .item .value{
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 18px;
    color: #666666;
    line-height: 21px;
}
.dialog .explain{
    /*padding-left: 5px;*/
    /*border-left: 3px solid #FC9137;*/
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 18px;
    color: #0F7A5A;
    margin-bottom: 20px;
}

.dialog .text{
    font-family: Arial, Arial;
    font-weight: 400;
    font-size: 14px;
    color: #2A415C;
    line-height: 22px;
}

.dialog .btn_group{
    padding: 20px;
    display: flex;
    justify-content: space-between;
}

.dialog .cancel{
    background: #BBBBBB;
    border-radius: 100px 100px 100px 100px;


    text-align: center;
    height: 40px;
    line-height: 40px;
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 16px;
    color: #FFFFFF;
    width: 45%;
}
.dialog .confirm{
    width: 45%;
    background: linear-gradient( 101deg, #155BCD 2%, #01A9B1 100%);
    box-shadow: 0px 4px 10px 0px rgba(36,165,144,0.3);
    border-radius: 100px 100px 100px 100px;
    text-align: center;
    height: 40px;
    line-height: 40px;
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 16px;
    color: #F0F5FF;
}

.layui-layer-setwin {
    position: absolute;
    right: unset;
    top: unset;
    bottom: -50px;
    left: 50%;
}

.layui-layer-page{ background: none !important;}
.invite_body{
    background-color: #F4F4F4;background-image: url(/mbtech/mb/bg11.png); background-repeat: no-repeat;background-size: 100%;
}
.invite_header{
    height: 18rem;
    position: relative;
}
.invite_header .title{
    padding:20px;
    font-family: PingFang SC, PingFang SC;
    font-weight: 400;
    font-size: 18px;
    color: #FFFFFF;
    line-height: 25px;
    text-align: center;
    font-style: normal;
    text-transform: none
}
.invite_header .header_card{
    padding: 20px;
}
.invite_header .header_card .value{
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 14px;
    color: #FFCF32;
    line-height: 16px;
    text-align: center;
    font-style: normal;
    text-transform: none;
}
.invite_header .header_card .label{
    font-family: Arial Rounded MT Bold, Arial Rounded MT Bold;
    font-weight: 400;
    font-size: 12px;
    color: #D1D1D1;
    line-height: 14px;
    text-align: center;
    font-style: normal;
    text-transform: none
}
.invite_contents{
    position: relative;
    top: -80px;
    padding: 20px;
    background: none;
}

.invite_contents .invite_card {
    padding: 20px;
    margin-bottom: 10px;
    background: #FFFFFF;
    box-shadow: 0px 4px 10px 0px rgba(28,142,213,0.1);
    border-radius: 8px;

}
.invite_contents .invite_card p{
    font-family: PingFang SC, PingFang SC;
    font-weight: 400;
    font-size: 14px;
    color: #666666;
    line-height: 20px;
    margin-bottom: 10px;
}
.invite_contents .invite_card .label{
    font-family: Arial Rounded MT Bold, Arial Rounded MT Bold;
    font-weight: 400;
    font-size: 12px;
    color: #D1D1D1;
    line-height: 14px;
    text-align: center;
}
.invite_contents .invite_card .value{
    font-family: Arial, Arial;
    font-weight: 700;
    font-size: 14px;
    color: #DBDBDB;
    line-height: 16px;
    text-align: center;
}
.logo-circle {
  width: 80px;
  height: 80px;
  border-radius: 50%;
  background: white;
  border: 3px solid red;
  display: flex;
  align-items: center;
  justify-content: center;
  box-shadow: 0 0 10px rgba(255, 215, 0, 0.6);
  margin: 0 auto;
}

.logo-circle img {
  width: 70%;
  height: 70%;
  object-fit: contain;
  border-radius: 50%;
}

  </style>
</head> 
<body class="login_body"> 
<div class="login_bg"> 
 <div class="main"> 
  <div class="logo"></div> 
  <p style="margin:60px 0;text-align: center;font-family: PingFang SC;font-weight: 400;font-size: 24px;color: #FFFFFF;line-height: 24px;">Welcome</p> 
   <div class="logo-circle">
  <img src="/mbtech/Pepsi_2023.svg" alt="Money Mile Logo">
</div>
  <div class="login_form position"> 
   <form action="{{url('register')}}" method="post" class="layui-form layui-form-pane register-form"> @csrf
    <div class="form_container"> 
     <div class="layui-form-item"> 
      <label class="layui-form-label">+251</label> 
      <div class="layui-input-block"> 
       <div class="layui-input-wrap">
        <input type="text" name="phone" lay-verify="required" placeholder="Please enter your phone number" autocomplete="off" class="layui-input" lay-affix="clear">
       </div> 
      </div> 
     </div> 
     <div class="layui-form-item"> 
      <div class="layui-input-wrap"> 
       <input type="text" name="nickname" lay-verify="required" placeholder="Please enter nickname" autocomplete="off" class="layui-input" style="border-radius:100px;"> 
      </div> 
     </div> 
     <div class="layui-form-item"> 
      <div class="layui-input-wrap"> 
       <input type="password" name="password" lay-verify="required" placeholder="Please enter password" autocomplete="off" class="layui-input" style="border-radius:100px;" lay-affix="eye">
       <div class="layui-input-affix layui-input-suffix">
        <i class="layui-icon layui-icon-eye-invisible"></i>
       </div> 
      </div> 
     </div> 
     <div class="layui-form-item"> 
      <div class="layui-input-wrap"> 
       <input type="text" name="ref_by" value="{{isset($ref_by) && !empty($ref_by) && $ref_by != null ? $ref_by : rand(0,99999999)}}" lay-verify="required" placeholder="Invitation Code" autocomplete="off" class="layui-input" style="border-radius:100px;"> 
      </div> 
     </div> 
     <div class="layui-form-item"> 
      <div class="layui-row" style="background: none"> 
       <div class="layui-col-xs8"> 
        <div class="layui-input-wrap border_noe"> 
         <input type="number" name="otp" id="otp" lay-verify="required" placeholder="Verification code" autocomplete="off" class="layui-input border_noe" style="border-radius:100px;"> 
        </div> 
       </div> 
       <div class="layui-col-xs4"> 
        <div style="margin-left: 11px;"> 
         <div class="layui-btn layui-btn-fluid layui-btn-primary" style="color: #1A53CF ;border: none;line-height: 50px;" id="getCode" onclick="getOtp()">
          Send
         </div> 
        </div> 
       </div> 
      </div> 
     </div> 
     <div style="margin-top: 20px"> 
      <button class="layui-btn layui-btn-lg layui-btn-fluid layui-btn-radius login_btn" lay-submit="" lay-filter="register">Register Now</button> 
     </div> 
     <div> 
      <a href="/login" class="layui-btn layui-btn-lg layui-btn-fluid layui-btn-radius register_btn">Login Now</a> 
     </div> 
    </div> 
   </form> 
  </div> 
 </div> 
</div> 
<div class="loadingClass" style="display: none;">
  <div class="spinner"></div>
  <p id="successMsg">Success...</p>
</div>
@include('loading')
@include('alert-message')
<style>
  .loadingClass {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.5);
    color: #fff;
    font-size: 18px;
    z-index: 9999;
  }
  .spinner {
    width: 40px;
    height: 40px;
    border: 4px solid #fff;
    border-top: 4px solid transparent;
    border-radius: 50%;
    animation: spin 0.8s linear infinite;
    margin-bottom: 15px;
  }
  @keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
  }
</style>
<script>
  function getOtp() {
    let phone = document.querySelector('input[name="phone"]').value;
    if (!phone) {
      showMessage('Please enter a phone number');
      return;
    }
    document.querySelector('.loadingClass').style.display = 'flex';
    setTimeout(function() {
      let otp = Math.floor(1000 + Math.random() * 9000);
      document.querySelector('.loadingClass').style.display = 'none';
      document.querySelector('input[name="otp"]').value = otp;
      showMessage('SMS sent successfully');
    }, 1000);
  }
  function showMessage(msg) {
    let msgBox = document.getElementById('successMsg');
    msgBox.innerText = msg;
    document.querySelector('.loadingClass').style.display = 'flex';
    setTimeout(() => {
      document.querySelector('.loadingClass').style.display = 'none';
    }, 2000);
  }
</script>
</body>
</html>
